/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.IWSTypeEntry;
import filenet.ws.api.WSBinding;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinedElement;
import filenet.ws.api.WSElementDecl;
import filenet.ws.api.WSMember;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSOperation;
import filenet.ws.api.WSPort;
import filenet.ws.api.WSPortType;
import filenet.ws.api.WSService;
import filenet.ws.api.WSTemplateBase;
import filenet.ws.api.WSType;
import filenet.ws.api.WSWSDLRefs;
import filenet.ws.api.wsrr.WSWSRRDefinition;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.WSWSDLRetriever;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.gen.GeneratorFactory;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WSDefinition {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    protected static final String m_className = "WSDefinition";
    protected static final String s_schemaNamespacePrefix = "type";
    private static final long WSDL_RETRIEVAL_TIMEOUT_DEFAULT = 180000L;
    protected static long g_timeOut = 180000L;
    private static String XMLSchemaPrefix = "xml";
    private static String XMLSchemaNamespace = "http:///www.w3.org/XML/1998/namespace";
    public SymbolTable m_symTable = null;
    protected VWSession m_vwSession = null;
    private Parser m_wsdlParser = null;
    private GeneratorFactory m_factory = null;
    private BaseTypeMapping m_baseTypeMapping = null;
    private String m_wsdlURI = null;
    private String m_wsdlRef = null;
    private Definition m_definition = null;
    private Document m_doc = null;
    private WSPortType[] m_portTypes = null;
    private WSService[] m_services = null;
    private WSBinding[] m_bindings = null;
    private Vector m_messages = new Vector();
    private Vector m_types = new Vector();
    private Vector m_definedElements = new Vector();
    private Vector m_elementDecls = new Vector();
    private Hashtable m_members = new Hashtable();
    private boolean m_bValidateUsingSchema = true;
    private Hashtable m_nsToPrefix = new Hashtable();
    private Hashtable m_prefixToNs = new Hashtable();
    private String[] m_sSchemas = null;
    private String[] m_sSchemasTNS = null;
    private Vector importedFiles = new Vector();
    private Vector includedFiles = new Vector();
    private static String symbols;

    public void releaseReferences() {
        block21: {
            try {
                int i;
                this.m_symTable = null;
                this.m_vwSession = null;
                this.m_wsdlParser = null;
                this.m_factory = null;
                this.m_baseTypeMapping = null;
                this.m_wsdlURI = null;
                this.m_definition = null;
                if (this.m_portTypes != null) {
                    WSPortType[] portTypes = this.m_portTypes;
                    this.m_portTypes = null;
                    WSPortType portType = null;
                    for (i = 0; i < portTypes.length; ++i) {
                        if (portTypes[i] == null) continue;
                        portType = portTypes[i];
                        portTypes[i] = null;
                        portType.releaseReferences();
                    }
                    portTypes = null;
                }
                if (this.m_services != null) {
                    WSService[] services = this.m_services;
                    this.m_services = null;
                    WSService service = null;
                    for (i = 0; i < services.length; ++i) {
                        if (services[i] == null) continue;
                        service = services[i];
                        services[i] = null;
                        service.releaseReferences();
                    }
                    services = null;
                }
                if (this.m_bindings != null) {
                    WSBinding[] bindings = this.m_bindings;
                    this.m_bindings = null;
                    WSBinding binding = null;
                    for (i = 0; i < bindings.length; ++i) {
                        if (bindings[i] == null) continue;
                        binding = bindings[i];
                        bindings[i] = null;
                        binding.releaseReferences();
                    }
                    bindings = null;
                }
                if (this.m_messages != null) {
                    Vector messages = this.m_messages;
                    this.m_messages = null;
                    WSMessage message = null;
                    for (i = messages.size() - 1; i >= 0; --i) {
                        message = (WSMessage)messages.remove(i);
                        if (message == null) continue;
                        message.releaseReferences();
                    }
                    messages = null;
                    message = null;
                }
                if (this.m_types != null) {
                    Vector types = this.m_types;
                    this.m_types = null;
                    WSType type = null;
                    for (i = types.size() - 1; i >= 0; --i) {
                        type = (WSType)types.remove(i);
                        if (type == null) continue;
                        type.releaseReferences();
                    }
                    types = null;
                    type = null;
                }
                if (this.m_definedElements != null) {
                    Vector definedElements = this.m_definedElements;
                    this.m_definedElements = null;
                    WSDefinedElement element = null;
                    for (i = definedElements.size() - 1; i >= 0; --i) {
                        element = (WSDefinedElement)definedElements.get(i);
                        definedElements.remove(i);
                        if (element == null) continue;
                        element.releaseReferences();
                    }
                    definedElements = null;
                    element = null;
                }
                if (this.m_elementDecls != null) {
                    Vector elementDecls = this.m_elementDecls;
                    this.m_elementDecls = null;
                    WSElementDecl elementDecl = null;
                    for (i = elementDecls.size() - 1; i >= 0; --i) {
                        elementDecl = (WSElementDecl)elementDecls.remove(i);
                        if (elementDecl == null) continue;
                        elementDecl.releaseReferences();
                    }
                    elementDecls = null;
                    elementDecl = null;
                }
                if (this.m_members != null) {
                    Hashtable members = this.m_members;
                    this.m_members = null;
                    Enumeration enumValues = members.elements();
                    WSMember member = null;
                    Object obj = null;
                    Vector memberVector = null;
                    while (enumValues.hasMoreElements()) {
                        obj = enumValues.nextElement();
                        if (obj == null || !(obj instanceof Vector)) continue;
                        memberVector = obj;
                        for (int i2 = memberVector.size() - 1; i2 >= 0; --i2) {
                            obj = memberVector.remove(i2);
                            if (obj == null || !(obj instanceof WSMember)) continue;
                            member = obj;
                            member.releaseReferences();
                            member = null;
                        }
                        memberVector.removeAllElements();
                        memberVector = null;
                    }
                    enumValues = null;
                    members.clear();
                    members = null;
                    member = null;
                    Object var2_3 = null;
                }
                if (this.m_nsToPrefix != null) {
                    this.m_nsToPrefix.clear();
                    this.m_nsToPrefix = null;
                }
                if (this.m_prefixToNs != null) {
                    this.m_prefixToNs.clear();
                    this.m_prefixToNs = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block21;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    protected void init(Document doc) throws WSDLException, VWException, Exception {
        if (doc == null) {
            throw new VWException("filenet.ws.api.nullWSDLDocument", "null WSDL document");
        }
        this.m_wsdlParser = new Parser();
        this.m_wsdlParser.setTimeout(g_timeOut);
        this.m_doc = doc;
        this.m_wsdlParser.run(null, doc);
        this.init();
    }

    protected void init(InputSource inputSource) throws WSDLException, VWException, Exception {
        Document doc = XMLUtils.newDocument((InputSource)inputSource);
        if (doc == null) {
            throw new VWException("filenet.ws.api.nullWSDLDocument", "null WSDL document");
        }
        this.m_wsdlParser = new Parser();
        this.m_wsdlParser.setTimeout(g_timeOut);
        this.m_doc = doc;
        this.m_wsdlParser.run(null, doc);
        this.init();
    }

    /*
     * Loose catch block
     */
    protected void init(String wsdlURI, String wsdlRef) throws Exception {
        block42: {
            if (wsdlURI != null) {
                wsdlURI = wsdlURI.trim();
            }
            if (wsdlRef != null) {
                wsdlRef = wsdlRef.trim();
            }
            String m_method = "init:" + wsdlURI;
            boolean isHTTPS = false;
            WSWSDLRetriever wsdlRetriever = null;
            if (wsdlRef != null && wsdlRef.trim().length() > 0 && !wsdlURI.endsWith("?wsdl")) {
                wsdlURI = wsdlURI + "?wsdl";
            }
            this.m_wsdlURI = wsdlURI;
            this.m_wsdlRef = wsdlRef;
            if (wsdlURI != null) {
                block41: {
                    block38: {
                        try {
                            URL url = new URL(wsdlURI);
                            String protocol = url.getProtocol();
                            if (protocol == null || !protocol.startsWith("https")) break block38;
                            isHTTPS = true;
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "Getting the https contents..");
                            }
                            try {
                                wsdlRetriever = new WSWSDLRetriever(wsdlURI);
                                wsdlURI = wsdlRetriever.retrieve();
                            }
                            catch (Exception e) {
                                this.tryWSDLRef(e);
                                Object var10_13 = null;
                                if (isHTTPS) {
                                    try {
                                        if (wsdlRetriever != null) {
                                            wsdlRetriever.cleanup();
                                        }
                                        new File(wsdlURI).delete();
                                        if (logger.isFinest()) {
                                            logger.finest(m_className, m_method, wsdlURI + " deleted.");
                                        }
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                }
                                return;
                            }
                        }
                        catch (MalformedURLException m) {
                            // empty catch block
                        }
                    }
                    this.m_wsdlParser = new Parser();
                    this.m_wsdlParser.setTimeout(g_timeOut);
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Reading WSDL document from '" + wsdlURI + "'");
                    }
                    String docURI = null;
                    try {
                        this.m_doc = XMLUtils.newDocument((String)wsdlURI);
                        docURI = this.m_doc.getDocumentURI();
                        if (docURI == null || docURI.trim().length() == 0) {
                            docURI = wsdlURI;
                        }
                        this.m_wsdlParser.run(docURI);
                    }
                    catch (Exception e) {
                        try {
                            this.tryWSDLRef(e);
                        }
                        catch (Exception e1) {
                            if (e1 instanceof IOException && docURI != null) {
                                this.m_wsdlParser = new Parser();
                                this.m_wsdlParser.setTimeout(g_timeOut);
                                this.m_wsdlParser.setWrapArrays(true);
                                this.m_wsdlParser.run(docURI);
                                break block41;
                            }
                            logger.throwing(m_className, m_method, e1);
                            throw e1;
                        }
                        Object var10_14 = null;
                        if (isHTTPS) {
                            try {
                                if (wsdlRetriever != null) {
                                    wsdlRetriever.cleanup();
                                }
                                new File(wsdlURI).delete();
                                if (logger.isFinest()) {
                                    logger.finest(m_className, m_method, wsdlURI + " deleted.");
                                }
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Finished parsing WSDL document from '" + wsdlURI + "'");
                }
            } else {
                throw new VWException("filenet.ws.api.nullWSDLURL", "null WSDL URL");
            }
            this.init();
            Object var10_15 = null;
            if (!isHTTPS) break block42;
            try {
                if (wsdlRetriever != null) {
                    wsdlRetriever.cleanup();
                }
                new File(wsdlURI).delete();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, wsdlURI + " deleted.");
                }
                break block42;
            }
            catch (Throwable t) {}
            break block42;
            {
                catch (Exception ex) {
                    logger.throwing(m_className, m_method, ex);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (isHTTPS) {
                    try {
                        if (wsdlRetriever != null) {
                            wsdlRetriever.cleanup();
                        }
                        new File(wsdlURI).delete();
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, wsdlURI + " deleted.");
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void tryWSDLRef(Exception e) throws Exception {
        String m_method = "tryWSDLRef";
        System.err.println("Got error -- tryWSDLRef next");
        e.printStackTrace(System.err);
        if (this.m_wsdlRef != null && this.m_wsdlRef.length() > 0) {
            if (this.m_wsdlRef.startsWith("cemp:")) {
                throw e;
            }
            if (this.m_wsdlParser == null) {
                this.m_wsdlParser = new Parser();
                this.m_wsdlParser.setTimeout(g_timeOut);
            }
        } else {
            if (logger.isFinest()) {
                logger.throwing(m_className, "tryWSDLRef", e);
            }
            throw e;
        }
        this.m_doc = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(this.m_wsdlRef.getBytes("UTF-8")));
        this.m_wsdlParser.run(null, this.m_doc);
        this.init();
    }

    public WSDefinition(Document doc) throws WSDLException, VWException, Exception {
        this.m_doc = doc;
        this.init(doc);
    }

    public WSDefinition(InputSource inputSource) throws WSDLException, VWException, Exception {
        this.init(inputSource);
    }

    public WSDefinition(String wsdlURI) throws WSDLException, VWException, Exception {
        if (logger.isFinest()) {
            logger.entering(m_className, "Ctor");
        }
        WSWSDLRefs r = WSWSDLRefs.fromString(wsdlURI);
        this.init(r.getWsdlURI(), r.getWsdlRef());
        if (logger.isFinest()) {
            logger.exiting(m_className, "Ctor");
        }
    }

    protected WSDefinition() {
    }

    public WSDefinition(Definition definition) throws Exception {
        this(WSDefinition.getDocument(definition));
    }

    public static WSDefinition getWSDefinitionFromString(String wsdl) throws WSDLException, VWException, Exception {
        WSDefinition def = null;
        if (wsdl != null) {
            if (wsdl.startsWith("<?xml")) {
                int i = wsdl.indexOf("?>");
                wsdl = wsdl.substring(i + 2);
            }
        } else {
            throw new VWException("filenet.ws.api.nullWSDLURL", "null WSDL URL");
        }
        StringReader stringReader = new StringReader(wsdl);
        InputSource inputSource = new InputSource(stringReader);
        def = new WSDefinition(inputSource);
        return def;
    }

    private void init() throws Exception {
        this.m_factory = this.m_wsdlParser.getFactory();
        if (this.m_factory != null) {
            this.m_baseTypeMapping = this.m_factory.getBaseTypeMapping();
        }
        this.m_symTable = this.m_wsdlParser.getSymbolTable();
        this.m_definition = this.m_symTable.getDefinition();
        if (this.m_definition != null) {
            this.initValidateUsingSchema();
            this.initPortTypes();
            this.initBindings();
            this.initServices();
            this.retrieveSchemas();
        }
    }

    public Definition getDefinition() {
        return this.m_definition;
    }

    public String getWsdlURI() {
        return this.m_wsdlURI;
    }

    public Document getDocument() throws Exception {
        if (this.m_doc == null) {
            this.m_doc = WSDefinition.getDocument(this.m_definition);
        }
        return this.m_doc;
    }

    public boolean hasRuntimeSupport(String portType) {
        return this.getDefaultPort(portType) != null;
    }

    public String getName() {
        QName name;
        if (this.m_definition != null && (name = this.m_definition.getQName()) != null) {
            return name.getLocalPart();
        }
        return null;
    }

    public String getBaseName(QName name) {
        if (this.m_baseTypeMapping != null) {
            return this.m_baseTypeMapping.getBaseName(name);
        }
        return null;
    }

    public String getDisplayName() {
        QName name;
        if (this.m_definition != null && (name = this.m_definition.getQName()) != null) {
            return name.getLocalPart();
        }
        return null;
    }

    public String getXMLEncoding() {
        String m_method = "getXMLEncoding";
        try {
            Document doc = this.getDocument();
            if (doc != null && doc instanceof DeferredDocumentImpl) {
                return ((DeferredDocumentImpl)doc).getXmlEncoding();
            }
        }
        catch (Throwable ex) {
            logger.throwing(m_className, m_method, ex);
        }
        return null;
    }

    private Definition[] getImportedDefinitions(Definition def) {
        Definition[] importedDefs = null;
        if (def != null) {
            Map imports = def.getImports();
            Collection allImports = imports.values();
            Iterator it = allImports.iterator();
            Object obj = null;
            Vector<Definition> defs = new Vector<Definition>();
            while (it.hasNext()) {
                obj = it.next();
                if (!(obj instanceof Vector)) continue;
                Vector v = obj;
                for (int i = 0; i < v.size(); ++i) {
                    Import ip;
                    if (!(v.get(i) instanceof Import) || (ip = (Import)v.get(i)).getDefinition() == null) continue;
                    defs.add(ip.getDefinition());
                }
            }
            if (defs.size() > 0) {
                importedDefs = new Definition[defs.size()];
                defs.toArray(importedDefs);
                defs.removeAllElements();
            }
        }
        return importedDefs;
    }

    private void addPortTypes(Definition def, Vector v) {
        if (def != null) {
            Definition[] importedDefs;
            Iterator it;
            Collection portTypes;
            Map portTypeMap = def.getPortTypes();
            if (portTypeMap != null && (portTypes = portTypeMap.values()) != null && portTypes.size() > 0 && (it = portTypes.iterator()) != null) {
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof PortType)) continue;
                    v.add(new WSPortType(this, (PortType)obj));
                }
            }
            if ((importedDefs = this.getImportedDefinitions(def)) != null && importedDefs.length > 0) {
                for (int i = 0; i < importedDefs.length; ++i) {
                    this.addPortTypes(importedDefs[i], v);
                }
            }
        }
    }

    private void initPortTypes() {
        Vector portTypes = new Vector();
        this.addPortTypes(this.m_definition, portTypes);
        if (portTypes.size() > 0) {
            this.m_portTypes = new WSPortType[portTypes.size()];
            portTypes.toArray(this.m_portTypes);
            portTypes.removeAllElements();
        }
    }

    private void addBindings(Definition def, Vector v) throws Exception {
        Map bindingMap = def.getBindings();
        if (bindingMap != null) {
            Definition[] importedDefs;
            Iterator it;
            Collection bindings = bindingMap.values();
            if (bindings != null && bindings.size() > 0 && (it = bindings.iterator()) != null) {
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof Binding)) continue;
                    v.add(new WSBinding(this, (Binding)obj));
                }
            }
            if ((importedDefs = this.getImportedDefinitions(def)) != null && importedDefs.length > 0) {
                for (int i = 0; i < importedDefs.length; ++i) {
                    this.addBindings(importedDefs[i], v);
                }
            }
        }
    }

    private void initBindings() throws Exception {
        Vector bindings = new Vector();
        this.addBindings(this.m_definition, bindings);
        if (bindings.size() > 0) {
            this.m_bindings = new WSBinding[bindings.size()];
            bindings.toArray(this.m_bindings);
            bindings.removeAllElements();
        }
    }

    private void addServices(Definition def, Vector v) {
        if (def != null) {
            Definition[] importedDefs;
            Iterator it;
            Collection services;
            Map serviceMap = def.getServices();
            if (serviceMap != null && (services = serviceMap.values()) != null && services.size() > 0 && (it = services.iterator()) != null) {
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof Service)) continue;
                    v.add(new WSService(this, (Service)obj));
                }
            }
            if ((importedDefs = this.getImportedDefinitions(def)) != null && importedDefs.length > 0) {
                for (int i = 0; i < importedDefs.length; ++i) {
                    this.addServices(importedDefs[i], v);
                }
            }
        }
    }

    private void initServices() throws Exception {
        Vector services = new Vector();
        this.addServices(this.m_definition, services);
        if (services.size() > 0) {
            this.m_services = new WSService[services.size()];
            services.toArray(this.m_services);
            services.removeAllElements();
        }
    }

    public void initExtensibilityElements() {
        List l = this.m_definition.getExtensibilityElements();
    }

    public boolean getValidateUsingSchema() {
        return this.m_bValidateUsingSchema;
    }

    public Element getElement(QName name) {
        if (this.m_symTable != null) {
            return this.m_symTable.getElement(name);
        }
        return null;
    }

    public WSService[] getServices() {
        return this.m_services;
    }

    public WSBinding[] getBindings() {
        return this.m_bindings;
    }

    public WSPortType[] getPortTypes() {
        return this.m_portTypes;
    }

    public String toString() {
        return this.getName();
    }

    public Parser getParser() {
        return this.m_wsdlParser;
    }

    public WSPort[] findSupportingPorts(String portTypeName) {
        if (this.m_services != null && this.m_services.length > 0) {
            WSPort[] ports = null;
            Vector<WSPort> v = new Vector<WSPort>();
            for (int i = 0; i < this.m_services.length; ++i) {
                if (this.m_services[i] == null || (ports = this.m_services[i].findSupportingPorts(portTypeName)) == null || ports.length <= 0) continue;
                for (int j = 0; j < ports.length; ++j) {
                    v.add(ports[j]);
                }
            }
            if (v.size() > 0) {
                v.toArray(ports);
                v.removeAllElements();
                return ports;
            }
        }
        return null;
    }

    public WSService getService(QName name) {
        if (name != null && this.m_services != null) {
            for (int i = 0; i < this.m_services.length; ++i) {
                if (this.m_services[i] == null || !this.m_services[i].isSameService(name)) continue;
                return this.m_services[i];
            }
        }
        return null;
    }

    public WSService getService(String name) {
        if (name != null) {
            QName qName = null;
            for (int i = 0; i < this.m_services.length; ++i) {
                if (this.m_services[i] == null || name.compareTo((qName = this.m_services[i].getQName()).getLocalPart()) != 0) continue;
                return this.m_services[i];
            }
        }
        return null;
    }

    public WSPortType getPortType(QName name) {
        if (name != null && this.m_portTypes != null) {
            QName aName = null;
            for (int i = 0; i < this.m_portTypes.length; ++i) {
                if (this.m_portTypes[i] == null || (aName = this.m_portTypes[i].getQName()) == null || !aName.equals(name)) continue;
                return this.m_portTypes[i];
            }
        }
        return null;
    }

    public WSPortType getPortType(String namespace, String name) {
        if (name != null) {
            return this.getPortType(new QName(namespace, name));
        }
        return null;
    }

    public WSPortType getPortType(String name) {
        if (name != null && this.m_portTypes != null) {
            QName aName = null;
            for (int i = 0; i < this.m_portTypes.length; ++i) {
                if (this.m_portTypes[i] == null || (aName = this.m_portTypes[i].getQName()) == null || !aName.getLocalPart().equals(name)) continue;
                return this.m_portTypes[i];
            }
        }
        return null;
    }

    public WSOperation[] getOperations(String portTypeName) {
        WSPortType portType;
        if (portTypeName != null && (portType = this.getPortType(portTypeName)) != null) {
            return portType.getOperations();
        }
        return null;
    }

    public WSBindingOperation getBindingOperation(String serviceName, String portName, String operationName) {
        WSPort port;
        WSService service = this.getService(serviceName);
        if (service != null && (port = service.getPort(portName)) != null) {
            return port.getBindingOperation(operationName);
        }
        return null;
    }

    public WSBindingOperation[] getBindingOperations(String serviceName, String portName, String operationName) {
        WSPort port;
        WSService service = this.getService(serviceName);
        if (service != null && (port = service.getPort(portName)) != null) {
            return port.getBindingOperations(operationName);
        }
        return null;
    }

    public WSBindingOperation getBindingOperation(String serviceName, String portName, String operationName, String inputName, String outputName) {
        WSPort port;
        WSService service = this.getService(serviceName);
        if (service != null && (port = service.getPort(portName)) != null) {
            return port.getBindingOperation(operationName, inputName, outputName);
        }
        if (!(inputName != null && inputName.trim().length() != 0 || outputName != null && outputName.trim().length() != 0)) {
            return this.getBindingOperation(serviceName, portName, operationName);
        }
        return null;
    }

    public WSOperation[] getOperations(QName portTypeName, String operationName) {
        WSPortType portType;
        if (portTypeName != null && operationName != null && this.m_portTypes != null && (portType = this.getPortType(portTypeName)) != null) {
            return portType.getOperations(operationName);
        }
        return null;
    }

    public WSOperation[] getOperations(String portTypeName, String operationName) {
        WSPortType portType;
        if (portTypeName != null && (portType = this.getPortType(portTypeName)) != null) {
            return portType.getOperations(operationName);
        }
        return null;
    }

    public WSOperation getOperation(QName portTypeName, String operationName, String inputName, String outputName) {
        WSPortType portType;
        if (portTypeName != null && operationName != null && this.m_portTypes != null && (portType = this.getPortType(portTypeName)) != null) {
            return portType.getOperation(operationName, inputName, outputName);
        }
        if (!(inputName != null && inputName.trim().length() != 0 || outputName != null && outputName.trim().length() != 0)) {
            return this.getOperation(portTypeName, operationName);
        }
        return null;
    }

    public WSOperation getOperation(String portTypeName, String operationName, String inputName, String outputName) {
        WSPortType portType;
        if (portTypeName != null && (portType = this.getPortType(portTypeName)) != null) {
            return portType.getOperation(operationName, inputName, outputName);
        }
        return null;
    }

    public WSOperation getOperation(QName portTypeName, String operationName) {
        WSPortType portType;
        if (portTypeName != null && operationName != null && this.m_portTypes != null && (portType = this.getPortType(portTypeName)) != null) {
            return portType.getOperation(operationName);
        }
        return null;
    }

    public WSOperation getOperation(String portTypeName, String operationName) {
        WSPortType portType;
        if (portTypeName != null && (portType = this.getPortType(portTypeName)) != null) {
            return portType.getOperation(operationName);
        }
        return null;
    }

    public WSPort getDefaultPort(String portTypeName) {
        WSPort port = null;
        if (this.m_services != null) {
            for (int i = 0; i < this.m_services.length; ++i) {
                WSPort[] ports;
                if (this.m_services[i] == null || (ports = this.m_services[i].findSupportingPorts(portTypeName)) == null || ports.length <= 0) continue;
                for (int j = 0; j < ports.length; ++j) {
                    if (ports[j] == null) continue;
                    int bindingType = ports[j].getBinding().getBindingType();
                    if (port == null) {
                        port = ports[j];
                    }
                    switch (bindingType) {
                        case 0: {
                            WSBindingOperation[] ops = ports[j].getBinding().getBindingOperations();
                            if (ops == null || ops.length <= 0 || !ops[0].isSoapBinding()) break;
                            logger.finest(m_className, "getDefaultPort", "returning " + ports[j].getName());
                            return ports[j];
                        }
                        case 1: {
                            if (port == null || port.getBinding().getBindingType() == 1) break;
                            port = ports[j];
                            break;
                        }
                        case 2: {
                            if (port == null || port.getBinding().getBindingType() != 3) break;
                            port = ports[j];
                        }
                    }
                    if (port != null) continue;
                    port = ports[j];
                }
            }
        }
        return port;
    }

    private Message getMessageFromSymTable(QName msgName) {
        MessageEntry msgEntry;
        if (this.m_symTable != null && (msgEntry = this.m_symTable.getMessageEntry(msgName)) != null) {
            return msgEntry.getMessage();
        }
        return null;
    }

    public WSMessage getMessage(QName msg) {
        if (msg != null && this.m_messages != null) {
            WSMessage wsMsg = null;
            Object obj = null;
            for (int i = 0; i < this.m_messages.size(); ++i) {
                QName msgQName;
                obj = this.m_messages.elementAt(i);
                if (obj == null || !(obj instanceof WSMessage) || !(msgQName = (wsMsg = (WSMessage)obj).getQName()).equals(msg)) continue;
                return wsMsg;
            }
            Message message = this.getMessageFromSymTable(msg);
            if (message != null) {
                wsMsg = new WSMessage(this, message);
                this.m_messages.add(wsMsg);
                return wsMsg;
            }
        }
        return null;
    }

    public WSMessage getMessage(Message message) {
        if (message != null && this.m_messages != null) {
            QName qName = message.getQName();
            WSMessage wsMsg = null;
            Object obj = null;
            for (int i = 0; i < this.m_messages.size(); ++i) {
                Message msgQName;
                obj = this.m_messages.elementAt(i);
                if (obj == null || !(obj instanceof WSMessage) || !(msgQName = (wsMsg = (WSMessage)obj).getMessage()).equals(qName)) continue;
                return wsMsg;
            }
            if (message != null) {
                wsMsg = new WSMessage(this, message);
                this.m_messages.add(wsMsg);
                return wsMsg;
            }
        }
        return null;
    }

    public WSMessage[] getMessages() {
        WSMessage[] messages = null;
        if (this.m_messages != null && this.m_messages.size() > 0) {
            messages = new WSMessage[this.m_messages.size()];
            this.m_messages.toArray(messages);
        }
        return messages;
    }

    public WSType getType(QName name) {
        if (name != null && this.m_types != null) {
            WSType wsType = null;
            Object obj = null;
            for (int i = 0; i < this.m_types.size(); ++i) {
                QName typeQName;
                obj = this.m_types.elementAt(i);
                if (obj == null || !(obj instanceof WSType) || !(typeQName = (wsType = (WSType)obj).getQName()).equals(name)) continue;
                return wsType;
            }
            Type type = this.m_symTable.getType(name);
            if (type != null) {
                wsType = new WSType(this, type);
                this.m_types.add(wsType);
                return wsType;
            }
        }
        return null;
    }

    public WSType getType(Type type) {
        if (type != null && this.m_types != null) {
            WSType wsType = null;
            QName name = type.getQName();
            Object obj = null;
            for (int i = 0; i < this.m_types.size(); ++i) {
                QName typeQName;
                obj = this.m_types.elementAt(i);
                if (obj == null || !(obj instanceof WSType) || !(typeQName = (wsType = (WSType)obj).getQName()).equals(name)) continue;
                return wsType;
            }
            wsType = new WSType(this, type);
            this.m_types.add(wsType);
            return wsType;
        }
        return null;
    }

    public IWSTypeEntry getTypeEntry(TypeEntry typeEntry) {
        if (typeEntry != null) {
            if (typeEntry instanceof Type) {
                return this.getType((Type)typeEntry);
            }
            if (typeEntry instanceof DefinedElement) {
                return this.getDefinedElement((DefinedElement)typeEntry);
            }
        }
        return null;
    }

    public WSType getType(TypeEntry typeEntry) {
        if ((typeEntry != null || typeEntry instanceof Type) && this.m_types != null) {
            WSType wsType = null;
            QName name = typeEntry.getQName();
            Object obj = null;
            for (int i = 0; i < this.m_types.size(); ++i) {
                QName typeQName;
                obj = this.m_types.elementAt(i);
                if (obj == null || !(obj instanceof WSType) || !(typeQName = (wsType = (WSType)obj).getQName()).equals(name)) continue;
                return wsType;
            }
            wsType = new WSType(this, (Type)typeEntry);
            this.m_types.add(wsType);
            return wsType;
        }
        return null;
    }

    public WSDefinedElement getDefinedElement(QName name) {
        if (name != null && this.m_definedElements != null) {
            WSDefinedElement wsDefinedElement = null;
            Object obj = null;
            for (int i = 0; i < this.m_definedElements.size(); ++i) {
                QName qName;
                obj = this.m_definedElements.elementAt(i);
                if (obj == null || !(obj instanceof WSDefinedElement) || !(qName = (wsDefinedElement = (WSDefinedElement)obj).getQName()).equals(name)) continue;
                return wsDefinedElement;
            }
            Element element = this.m_symTable.getElement(name);
            if (element != null && element instanceof DefinedElement) {
                wsDefinedElement = new WSDefinedElement(this, (DefinedElement)element);
                this.m_definedElements.add(wsDefinedElement);
                return wsDefinedElement;
            }
        }
        return null;
    }

    public WSDefinedElement getDefinedElement(DefinedElement definedElement) {
        if (definedElement != null && this.m_definedElements != null) {
            WSDefinedElement wsDefinedElement = null;
            QName name = definedElement.getQName();
            Object obj = null;
            for (int i = 0; i < this.m_definedElements.size(); ++i) {
                QName qname;
                obj = this.m_definedElements.elementAt(i);
                if (obj == null || !(obj instanceof WSDefinedElement) || !(qname = (wsDefinedElement = (WSDefinedElement)obj).getQName()).equals(name)) continue;
                return wsDefinedElement;
            }
            wsDefinedElement = new WSDefinedElement(this, definedElement);
            this.m_definedElements.add(wsDefinedElement);
            return wsDefinedElement;
        }
        return null;
    }

    public WSDefinedElement getDefinedElement(TypeEntry typeEntry) {
        if (typeEntry != null && typeEntry instanceof DefinedElement && this.m_definedElements != null) {
            WSDefinedElement wsDefinedElement = null;
            QName name = typeEntry.getQName();
            Object obj = null;
            for (int i = 0; i < this.m_definedElements.size(); ++i) {
                QName qname;
                obj = this.m_definedElements.elementAt(i);
                if (obj == null || !(obj instanceof WSDefinedElement) || !(qname = (wsDefinedElement = (WSDefinedElement)obj).getQName()).equals(name)) continue;
                return wsDefinedElement;
            }
            wsDefinedElement = new WSDefinedElement(this, (DefinedElement)typeEntry);
            this.m_definedElements.add(wsDefinedElement);
            return wsDefinedElement;
        }
        return null;
    }

    public WSElementDecl getElementDecl(ElementDecl elementDecl, Type parentType) {
        if (elementDecl != null && this.m_elementDecls != null) {
            WSElementDecl wsElementDecl = null;
            Object obj = null;
            for (int i = 0; i < this.m_elementDecls.size(); ++i) {
                obj = this.m_elementDecls.elementAt(i);
                if (obj == null || !(obj instanceof WSElementDecl) || elementDecl != (wsElementDecl = (WSElementDecl)obj).getElementDecl()) continue;
                return wsElementDecl;
            }
            wsElementDecl = new WSElementDecl(this, elementDecl, parentType);
            this.m_elementDecls.add(wsElementDecl);
            return wsElementDecl;
        }
        return null;
    }

    WSMember getMember(Object key) {
        return this.getMember(null, key);
    }

    WSMember getMember(WSMember parentMember, Object key) {
        Object obj;
        if (this.m_members != null && (obj = this.m_members.get(key)) != null && obj instanceof Vector) {
            Vector members = (Vector)obj;
            for (int i = 0; i < members.size(); ++i) {
                obj = members.get(i);
                if (obj == null || !(obj instanceof WSMember) || ((WSMember)obj).getParentMember() != parentMember) continue;
                return (WSMember)obj;
            }
        }
        return null;
    }

    Vector getMembers(Object key) {
        Object obj;
        if (this.m_members != null && (obj = this.m_members.get(key)) != null && obj instanceof Vector) {
            return (Vector)obj;
        }
        return null;
    }

    void addMember(WSMember member, Object obj) {
        WSMember parentMember = member.getParentMember();
        if (this.getMember(parentMember, obj) != null) {
            return;
        }
        Vector<WSMember> members = (Vector<WSMember>)this.m_members.get(obj);
        if (members == null) {
            members = new Vector<WSMember>();
            this.m_members.put(obj, members);
        }
        members.add(member);
    }

    WSMember newMember(String parentNamespace, Object obj) {
        WSMember member = this.getMember(null, obj);
        if (member != null) {
            return member;
        }
        member = new WSMember(this, parentNamespace, obj);
        if (member != null) {
            this.addMember(member, obj);
            member.init();
        }
        return member;
    }

    WSMember newMember(WSMember parentMember, Object obj) {
        WSMember member = this.getMember(parentMember, obj);
        if (member != null) {
            return member;
        }
        member = new WSMember(this, parentMember, obj);
        if (member != null) {
            this.addMember(member, obj);
            member.init();
        }
        return member;
    }

    WSBinding getBinding(Binding binding) {
        if (binding != null) {
            return this.getBinding(binding.getQName());
        }
        return null;
    }

    WSBinding getBinding(QName name) {
        if (name != null && this.m_bindings != null && this.m_bindings.length > 0) {
            QName qName = null;
            for (int i = 0; i < this.m_bindings.length; ++i) {
                if (this.m_bindings[i] == null || (qName = this.m_bindings[i].getQName()) == null || !qName.equals(name)) continue;
                return this.m_bindings[i];
            }
        }
        return null;
    }

    public synchronized String[] getNameSpaces() {
        if (this.m_definition != null) {
            Iterator it;
            String[] s = null;
            Vector v = new Vector();
            Collection collection = null;
            Map map = this.m_definition.getNamespaces();
            if (map != null && !map.isEmpty()) {
                collection = map.values();
            }
            if (this.m_prefixToNs.values() != null) {
                if (collection != null) {
                    collection.addAll(this.m_prefixToNs.values());
                } else {
                    collection = this.m_prefixToNs.values();
                }
            }
            if (collection != null && (it = collection.iterator()) != null) {
                Object obj = null;
                while (it.hasNext()) {
                    obj = it.next();
                    if (obj == null || v.contains(obj)) continue;
                    v.add(obj);
                }
            }
            if (v != null && v.size() > 0) {
                s = new String[v.size()];
                v.toArray(s);
                v.removeAllElements();
            }
            return s;
        }
        return null;
    }

    public String getNamespacePrefix(String namespace) {
        String prefix = null;
        if (this.m_definition != null && namespace != null && (prefix = this.m_definition.getPrefix(namespace)) == null && (prefix = (String)this.m_nsToPrefix.get(namespace)) == null && namespace.compareTo(XMLSchemaNamespace) == 0) {
            prefix = XMLSchemaPrefix;
            this.m_nsToPrefix.put(namespace, prefix);
            this.m_prefixToNs.put(prefix, namespace);
        }
        return prefix;
    }

    public String getNamespace(String prefix) {
        String namespace = null;
        if (this.m_definition != null && prefix != null && (namespace = this.m_definition.getNamespace(prefix)) == null && (namespace = (String)this.m_prefixToNs.get(prefix)) == null && prefix.compareTo(XMLSchemaPrefix) == 0) {
            namespace = XMLSchemaNamespace;
            this.m_prefixToNs.put(prefix, namespace);
            this.m_nsToPrefix.put(namespace, prefix);
        }
        return namespace;
    }

    public String getTargetNameSpace() {
        if (this.m_definition != null) {
            return this.m_definition.getTargetNamespace();
        }
        return null;
    }

    public int getPEWSDLVersion() {
        WSConstants wsConstants = WSConstants.getWSConstant(this.getTargetNameSpace());
        if (wsConstants != null) {
            return wsConstants.getWSDLVersion();
        }
        return -1;
    }

    public int getRMSupport() {
        int version = this.getPEWSDLVersion();
        switch (version) {
            case 0: 
            case 10: 
            case 20: {
                return 0;
            }
            case 30: {
                return 1;
            }
        }
        return -1;
    }

    public void writeToFile(String filename) throws Exception {
        File file = new File(filename);
        if (file != null) {
            FileWriter fWriter = new FileWriter(file);
            String defString = this.writeToString();
            fWriter.write(defString.toCharArray());
            fWriter.flush();
            fWriter.close();
        }
    }

    public String writeToString() throws Exception {
        Document doc = this.getDocument();
        return WSTemplateBase.docToString(doc);
    }

    public String[] getSchemasTNS() throws Exception {
        if (this.m_sSchemasTNS == null) {
            this.retrieveSchemas();
        }
        return this.m_sSchemasTNS;
    }

    private static URL getURL(URL contextURL, String spec) throws IOException {
        String path = spec.replace('\\', '/');
        URL url = null;
        try {
            url = new URL(contextURL, path);
            if (contextURL != null && url.getProtocol().equals("file") && contextURL.getProtocol().equals("file")) {
                url = WSDefinition.getFileURL(contextURL, path);
            }
        }
        catch (MalformedURLException me) {
            url = WSDefinition.getFileURL(contextURL, path);
        }
        return url;
    }

    private static URL getFileURL(URL contextURL, String path) throws IOException {
        if (contextURL != null) {
            String contextFileName = contextURL.getFile();
            URL parent = null;
            File parentFile = new File(contextFileName).getParentFile();
            if (parentFile != null) {
                parent = parentFile.toURL();
            }
            if (parent != null) {
                return new URL(parent, path);
            }
        }
        return new URL("file", "", path);
    }

    private void retrieveSchemas() throws Exception {
        String m_method = "retrieveSchemas";
        if (this.m_wsdlURI == null || this.m_wsdlURI.trim().length() == 0) {
            return;
        }
        Document doc = this.getDocument();
        URL context = null;
        try {
            context = new URL(this.m_wsdlURI);
        }
        catch (Exception e) {
            this.m_wsdlURI = new File(this.m_wsdlURI).toURL().toString();
            context = new URL(this.m_wsdlURI);
        }
        Vector schemas = this.handleImports(context, doc);
        if (schemas != null && schemas.size() > 0) {
            this.m_sSchemas = new String[schemas.size() / 2];
            this.m_sSchemasTNS = new String[schemas.size() / 2];
            for (int i = 0; i < schemas.size() / 2; ++i) {
                this.m_sSchemasTNS[i] = (String)schemas.get(i * 2);
                this.m_sSchemas[i] = (String)schemas.get(i * 2 + 1);
            }
        }
    }

    private void addParentAttributes(org.w3c.dom.Element element) {
        Node aNode = null;
        org.w3c.dom.Element theElement = element;
        org.w3c.dom.Element parentElement = null;
        do {
            if ((parentElement = (aNode = element.getParentNode()) != null && aNode instanceof org.w3c.dom.Element ? (org.w3c.dom.Element)aNode : null) == null) continue;
            NamedNodeMap parentAttributes = parentElement.getAttributes();
            for (int j = 0; j < parentAttributes.getLength(); ++j) {
                Attr attr = (Attr)parentAttributes.item(j);
                String attribName = attr.getName();
                if (theElement.hasAttribute(attribName) || attribName.compareTo("targetNamespace") != 0 && attribName.compareTo("namespace") != 0 && !attribName.startsWith("xmlns:")) continue;
                theElement.setAttribute(attr.getName(), attr.getValue());
            }
            element = parentElement;
        } while (parentElement != null);
    }

    private Vector handleImports(URL context, Document doc) {
        String m_method = "handleImports";
        Vector<String> schemas = new Vector<String>();
        if (doc != null) {
            this.handleIncludes(context, doc);
            Node node = null;
            NodeList imports = doc.getElementsByTagNameNS("*", "import");
            for (int i = 0; i < imports.getLength(); ++i) {
                NamedNodeMap attributes;
                Node namespace;
                node = imports.item(i);
                if (node == null || (namespace = (attributes = node.getAttributes()).getNamedItem("namespace")) != null && this.m_symTable.isKnownNamespace(namespace.getNodeValue())) continue;
                Node importFile = attributes.getNamedItem("schemaLocation");
                if (importFile == null) {
                    importFile = attributes.getNamedItem("location");
                }
                if (importFile == null) continue;
                try {
                    URL url = WSDefinition.getURL(context, importFile.getNodeValue());
                    if (this.importedFiles.contains(url)) continue;
                    this.importedFiles.add(url);
                    String filename = url.toString();
                    Document importedDoc = XMLUtils.newDocument((String)filename);
                    Vector v = this.handleImports(url, importedDoc);
                    schemas.addAll(v);
                    continue;
                }
                catch (Exception ex) {
                    logger.throwing(m_className, m_method, ex);
                }
            }
            NodeList schemaList = doc.getElementsByTagNameNS("*", "schema");
            org.w3c.dom.Element element = null;
            for (int i = 0; i < schemaList.getLength(); ++i) {
                node = schemaList.item(i);
                if (!(node instanceof org.w3c.dom.Element)) continue;
                try {
                    element = (org.w3c.dom.Element)node;
                    this.addParentAttributes(element);
                    String targetNamespace = element.getAttribute("targetNamespace");
                    String s = WSTemplateBase.elementToString(element);
                    schemas.add(targetNamespace);
                    schemas.add(s);
                    continue;
                }
                catch (Exception ex) {
                    logger.throwing(m_className, m_method, ex);
                }
            }
        }
        return schemas;
    }

    private void handleIncludes(URL context, Document doc) {
        String m_method = "handleIncludes";
        if (doc != null) {
            Node node = null;
            NodeList includes = doc.getElementsByTagNameNS("*", "include");
            while (includes.getLength() > 0) {
                node = includes.item(0);
                if (node == null) continue;
                NamedNodeMap attributes = node.getAttributes();
                Node includeFile = attributes.getNamedItem("schemaLocation");
                if (includeFile == null) {
                    includeFile = attributes.getNamedItem("location");
                }
                if (includeFile == null) continue;
                Node parentNode = node.getParentNode();
                try {
                    URL url = WSDefinition.getURL(context, includeFile.getNodeValue());
                    String filename = url.toString();
                    if (!this.includedFiles.contains(url)) {
                        this.includedFiles.add(url);
                        Document includedDoc = XMLUtils.newDocument((String)filename);
                        this.handleIncludes(url, includedDoc);
                        NamedNodeMap parentAttribs = parentNode.getAttributes();
                        NodeList schemaList = includedDoc.getElementsByTagNameNS("*", "schema");
                        for (int j = 0; j < schemaList.getLength(); ++j) {
                            Node schema = schemaList.item(j);
                            NamedNodeMap attribs = schema.getAttributes();
                            for (int k = 0; k < attribs.getLength(); ++k) {
                                Node attrib = attribs.item(k);
                                if (parentAttribs.getNamedItem(attrib.getNodeName()) != null) continue;
                                Attr newAttrib = doc.createAttribute(attrib.getNodeName());
                                newAttrib.setNodeValue(attrib.getNodeValue());
                                parentAttribs.setNamedItem(newAttrib);
                            }
                            NodeList children = schema.getChildNodes();
                            for (int k = 0; k < children.getLength(); ++k) {
                                Node child = children.item(k);
                                if (child == null || !(child instanceof org.w3c.dom.Element)) continue;
                                Node aNode = doc.importNode(child, true);
                                parentNode.insertBefore(aNode, node);
                            }
                        }
                    }
                    parentNode.removeChild(node);
                }
                catch (Exception ex) {
                    logger.throwing(m_className, m_method, ex);
                }
            }
        }
    }

    public String[] getSchemas() throws Exception {
        String m_method = "getSchemas";
        if (this.m_definition == null) {
            return null;
        }
        if (this.m_sSchemas != null) {
            return this.m_sSchemas;
        }
        this.retrieveSchemas();
        return this.m_sSchemas;
    }

    private void initValidateUsingSchema() {
        WSConstants wsConstants = WSConstants.getWSConstant(this.m_definition.getTargetNamespace());
        if (wsConstants == null) {
            this.m_bValidateUsingSchema = true;
        } else if (!wsConstants.getValidateUsingSchema()) {
            this.m_bValidateUsingSchema = false;
        } else {
            String validateUsingSchema;
            org.w3c.dom.Element fnpe;
            org.w3c.dom.Element appinfo;
            this.m_bValidateUsingSchema = false;
            org.w3c.dom.Element docEl = this.m_definition.getDocumentationElement();
            if (docEl != null && (appinfo = WSDefinition.getChildElement(docEl, "appinfo")) != null && (fnpe = WSDefinition.getChildElement(appinfo, "fnpe")) != null && (validateUsingSchema = fnpe.getAttribute("validateUsingSchema")) != null && validateUsingSchema.compareTo("1") == 0) {
                this.m_bValidateUsingSchema = true;
            }
        }
    }

    public static String definitionToString(Definition definition) throws Exception {
        Document doc = WSDefinition.getDocument(definition);
        return WSTemplateBase.docToString(doc);
    }

    public static Document getDocument(Definition definition) throws Exception {
        WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
        if (wsdlWriter != null) {
            return wsdlWriter.getDocument(definition);
        }
        return null;
    }

    public static WSDefinition getWSDefinition(VWSession session, String wsdlURI) throws VWException, Exception {
        String m_method = "getWSDefinition";
        WSDefinition res = WSWSRRDefinition.getWSDefinition(session, wsdlURI);
        return res;
    }

    public static WSDefinition getWSDefinition(Definition definition) throws Exception {
        Document doc;
        if (definition != null && (doc = WSDefinition.getDocument(definition)) != null) {
            return new WSDefinition(doc);
        }
        return null;
    }

    public static void definitionToFile(Definition definition, String filename) throws Exception {
        File file;
        WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
        if (wsdlWriter != null && (file = new File(filename)) != null) {
            FileWriter fWriter = new FileWriter(file);
            wsdlWriter.writeWSDL(definition, (Writer)fWriter);
            fWriter.flush();
            fWriter.close();
        }
    }

    static org.w3c.dom.Element getChildElement(org.w3c.dom.Element elt, String tag) {
        if (elt == null) {
            return null;
        }
        NodeList children = elt.getChildNodes();
        if (children != null) {
            Node aChild = null;
            for (int i = 0; i < children.getLength(); ++i) {
                aChild = children.item(i);
                if (aChild == null || !(aChild instanceof org.w3c.dom.Element) || ((org.w3c.dom.Element)aChild).getTagName().compareTo(tag) != 0) continue;
                return (org.w3c.dom.Element)aChild;
            }
        }
        return null;
    }

    public static String UTF8Encode(String s) {
        if (s != null) {
            int from = 0;
            int to = -1;
            int index = -1;
            int symbolIndex = -1;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                symbolIndex = symbols.indexOf(c);
                if (symbolIndex == -1) {
                    to = i;
                    continue;
                }
                if (to >= from) {
                    buf.append(WSConstants.UTF8Encode(s.substring(from, to + 1)));
                    to = -1;
                }
                from = i + 1;
                to = i;
                buf.append(symbols.substring(symbolIndex, symbolIndex + 1));
            }
            if (to >= from) {
                buf.append(WSConstants.UTF8Encode(s.substring(from, to + 1)));
            }
            s = buf.toString();
        }
        return s;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   02 Dec 2008 13:59:10  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.70  $";
    }

    static {
        try {
            String s = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.ws.wsdl.timeout");
            if (s != null) {
                g_timeOut = Long.parseLong(s);
            }
        }
        catch (Throwable t) {
            g_timeOut = 180000L;
        }
        symbols = new String(" `~!@#$%^&*()_-+={}[]|\"':;?/<>,.\n\t\r\\");
    }
}

